version	equ	1

	include	defs.asm

;Ported from Tim Krauskopf's micnet.asm, an assembly language
;driver for the MICOM-Interlan NI5210 by Russell Nelson.  Any bugs
;are due to Russell Nelson.
;3c523 version Dan Lanciani ddl@harvard.* (received 5-18-89)
;Added Brad Clements' 1500 byte MTU, Russell Nelson.

;  Copyright, 1988, 1989, Russell Nelson

;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation, version 1.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

code	segment	byte public
	assume	cs:code, ds:code

;
;  Equates for controlling the 3c523 board
;
IOC	EQU	6

BASE_OFFSET	EQU	0c000h		; base offset for the board.
BUS_TYPE	equ	0		; bus type in scb.


	public	int_no
int_no		db	3,0,0,0		; interrupt number
io_addr		dw	300h,0		; I/O address for card
base_addr	dw  	0c000h,0	; base segment for board

	public	driver_class, driver_type, driver_name
driver_class	db	1		;from the packet spec
driver_type	db	13		;from the packet spec
driver_name	db	"3C523",0	;name of the driver.

doca:
;we may be called from places in which ds is unknown.
	assume	ds:nothing
	loadport
	setport IOC
	mov	al, 0c7h
	pushf
	cli
	out	dx, al
	jmp	$+2
	jmp	$+2
	jmp	$+2
	mov	al, 087h
	out	dx, al
	popf
	ret
	assume	ds:code
;yet, we really should assume ds==code for the rest of this stuff.


;
; Here we include the code that is common between 82586 implementations.
; Everything above this is resident.
	include	82586.asm
; Everything below this is discarded upon installation.

	public	usage_msg
usage_msg	db	"usage: 3c523 <packet_int_no> <int_no> <io_addr> <base_addr>",CR,LF,'$'

	public	copyright_msg
copyright_msg	db	"Packet driver for the 3C523, version ",'0'+majver,".",'0'+version,CR,LF
		db	"Portions Copyright 1988 The Board of Trustees of the University of Illinois",CR,LF,'$'

check_board:
	loadport
	setport	IOC
	mov	al,23h
	out	dx,al		; reset the chip
	jmp	$+2
	jmp	$+2
	jmp	$+2
	mov	al,63h
	out	dx,al		; reset the chip
	jmp	$+2
	jmp	$+2
	jmp	$+2
	mov	al,23h
	out	dx,al		; reset the chip
	jmp	$+2
	jmp	$+2
	jmp	$+2
	ret

lbca:	loadport
	setport IOC
	mov	al, 0e3h
	out	dx, al
	jmp	$+2
	jmp	$+2
	jmp	$+2
	mov	al, 0a3h
	out	dx, al
	ret


code	ends

	end

